#include "MDSF05_SFR.h"
#include "XSFR_GLOBAL.h"
#include "Allhex.h"

//********************************************************************************
//								  Break
//********************************************************************************
void PWM_SetBreak (void){		// low side pwm brake; User mode
	MPWMCONT1 = SWAP | ActiveLow<<2 | ForceLow;	// x,u
	SYNC = 0x55;
	MPWMCONT2 = ActiveLow<<6 | ForceLow<<4 | ActiveLow<<2 | ForceLow;// z,w,y,v
	SYNC = 0x55;
}
void PWM_SetBreakForce (void){	//low side all brake; Auto mode
	MPWMCONT1 = SWAP | ForceHi<<2 | ForceLow; // x,u
	SYNC = 0x55;
	MPWMCONT2 = ForceHi<<6 | ForceLow<<4 | ForceHi<<2 | ForceLow; // z,w,y,v
	SYNC = 0x55;
}
void PWM_Duty (unsigned int duty){
	SFR_PAGE = 1;// PWM Duty U
	MPWMDATA = duty;
	SYNC = 0x55;
	SFR_PAGE = 2;// PWM Duty V
	MPWMDATA = duty;
	SYNC = 0x55;
	SFR_PAGE = 3;// PWM Duty W
	MPWMDATA = duty;
	SYNC = 0x55;
}
//********************************************************************************
//								  PWM SET ALL OFF
//********************************************************************************
void PWM_SetAllOff (void){
	MPWMCONT1 = SWAP | 0x00;
	SYNC = 0x55;
	MPWMCONT2 = 0x00;
	SYNC = 0x55;
}

void PWM_SetActive (void){
	MPWMCONT1 = SWAP | ActiveLow<<2 | ActiveHi;
	SYNC = 0x55;
	MPWMCONT2 = ActiveLow<<6 | ActiveHi<<4 | ActiveLow<<2 | ActiveHi;
	SYNC = 0x55;
}
//********************************************************************************
//								   PWM INIT
//********************************************************************************
void PWM_Init (void){
	SFR_PAGE = 0;
	MPWMDATA = MPWMDATA_REGS;
	SYNC = 0x55;
	MPWMINV = MPWMINV_REGS;
	SYNC = 0x55;
	MPWMDB = MPWMDB_REGS;
	SYNC = 0x55;
	PWM_SetAllOff();
}
#if (Square_Parking == 1)
void PWMSet(unsigned short uvw_number){
	switch (uvw_number){
	case 0:
		SFR_PAGE = 3; // PWM Duty W
		MPWMDATA = 0;
		SYNC = 0x55;
		
		SFR_PAGE = 2; // PWM Duty V
		MPWMDATA = 0;
		SYNC = 0x55;
	
		SFR_PAGE = 1; // PWM Duty U
		MPWMDATA = Startup_duty;
		SYNC = 0x55;
		break;

	case 1:
		
		SFR_PAGE = 2; // PWM Duty V
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 3; // PWM Duty W
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 1; // PWM Duty U
		MPWMDATA = Startup_duty;
		break;

	case 2:
		SFR_PAGE = 1; // PWM Duty U
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 3; // PWM Duty W
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 2; // PWM Duty V
		MPWMDATA = Startup_duty;
		break;

	case 3:
		SFR_PAGE = 1; // PWM Duty U
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 3; // PWM Duty W
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 2; // PWM Duty V
		MPWMDATA = Startup_duty;
		break;

	case 4:
		SFR_PAGE = 2; // PWM Duty V
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 1; // PWM Duty U
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 3; // PWM Duty W
		MPWMDATA = Startup_duty;
		break;

	case 5:
		SFR_PAGE = 1; // PWM Duty U
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 2; // PWM Duty V
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 3; // PWM Duty W
		MPWMDATA = Startup_duty;

		break;

	default:
		SFR_PAGE = 1; // PWM Duty U
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 2; // PWM Duty V
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 3; // PWM Duty W
		MPWMDATA = 0;
		SYNC = 0x55;
		break;
	}
	SYNC = 0x55;
}
void SwitchPhase(unsigned short dirUVW){
	switch (dirUVW){
	case 0:											//uv
		MPWMCONT1 = SWAP | ForceLow << 2 | ActiveLow; // x,u
		SYNC = 0x55;
		MPWMCONT2 = ForceLow << 6 | ForceLow << 4 | ForceHi << 2 | ForceLow; // z,w,y,v
		SYNC = 0x55;
		break;

	case 1:											//uw
		MPWMCONT1 = SWAP | ForceLow << 2 | ActiveLow; // x,u
		SYNC = 0x55;
		MPWMCONT2 = ForceHi << 6 | ForceLow << 4 | ForceLow << 2 | ForceLow; // z,w,y,v
		SYNC = 0x55;
		break;

	case 2:											 //vw
		MPWMCONT1 = SWAP | ForceLow << 2 | ForceLow; // x,u
		SYNC = 0x55;
		MPWMCONT2 = ForceHi << 6 | ForceLow << 4 | ForceLow << 2 | ActiveLow; // z,w,y,v
		SYNC = 0x55;
		break;

	case 3:											  //vu
		MPWMCONT1 = SWAP | ForceHi << 2 | ForceLow;	  // x,u
		SYNC = 0x55;
		MPWMCONT2 = ForceLow << 6 | ForceLow << 4 | ForceLow << 2 | ActiveLow; // z,w,y,v
		SYNC = 0x55;
		break;

	case 4:											  //wu
		MPWMCONT1 = SWAP | ForceHi << 2 | ForceLow;	  // x,u
		SYNC = 0x55;
		MPWMCONT2 = ForceLow << 6 | ActiveLow << 4 | ForceLow << 2 | ForceLow; // z,w,y,v
		SYNC = 0x55;
		break;

	case 5:											 //wv /Lside Hside
		MPWMCONT1 = SWAP | ForceLow << 2 | ForceLow; // x,u
		SYNC = 0x55;
		MPWMCONT2 = ForceLow << 6 | ActiveLow << 4 | ForceHi << 2 | ForceLow; // z,w,y,v
		SYNC = 0x55;
		break;

	default:

		MPWMCONT1 = SWAP | ForceLow << 2 | ForceLow; // x,u
		SYNC = 0x55;
		MPWMCONT2 = ForceLow << 6 | ForceLow << 4 | ForceLow << 2 | ForceLow; // z,w,y,v
		SYNC = 0x55;
		break;
	}
}
#endif